/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2015, Intel Corporation                                                                    *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsddevice_i.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsddevice_i.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_
#define NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_

#include <naltypes.h>
#include <nalcodes.h>
#include <sys/sockio.h>

#define NAL_FREEBSD_IS_BIT_SET(Value,Bit)           (((Value) & (1<<Bit)) == (1<<Bit))
#define NAL_FREEBSD_IS_BIT_CLEAR(Value,Bit)         (((Value) & (1<<Bit)) == 0)

#define NAL_FREEBSD_PCI_BAR_0_REGISTER_OFFSET       0x10
#define NAL_FREEBSD_PCI_BAR_1_REGISTER_OFFSET       0x14
#define NAL_FREEBSD_PCI_BAR_2_REGISTER_OFFSET       0x18
#define NAL_FREEBSD_PCI_BAR_3_REGISTER_OFFSET       0x1C
#define NAL_FREEBSD_PCI_BAR_4_REGISTER_OFFSET       0x20
#define NAL_FREEBSD_PCI_BAR_5_REGISTER_OFFSET       0x24

#define NAL_FREEBSD_IS_PCI_MEMORY_BAR(Register)     NAL_FREEBSD_IS_BIT_CLEAR(Register,0)
#define NAL_FREEBSD_IS_PCI_IO_BAR(Register)         NAL_FREEBSD_IS_BIT_SET(Register,0)

#define NAL_FREEBSD_GET_PCI_MEMORY_BAR_BASE_ADDRESS(Register)   (Register & 0xFFFFFFF0) >> 4
#define NAL_FREEBSD_GET_PCI_IO_BAR_BASE_ADDRESS(Register)       (Register & 0xFFFFFFFC) >> 2

#define NAL_FREEBSD_ETH_IOCTL                       SIOCGDRVSPEC
#define NAL_FREEBSD_WETH_IOCTL                      SIOCSDRVSPEC

#define MAX_DEVICE_NUM                              512

#define I40E_IOC              ((((((('E' << 4) + '1') << 4) \
                              + 'K') << 4) + 'G') << 4)
#define I40E_NVM_ACCESS       (I40E_IOC | 5)    /* used by nvm update */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/route.h>

/* Because the OS does not depend on any device context to talk to the
 * MMIO or PORT IO, the _Nal{Read/Write}PortOs{8,16,32} and
 * _Nal{Read/Write}RegisterOs{8,16,32} functions are macros to the
 * Operating System Interface functions.
 *
 * These are also defined in the driver compilation path in freebsddriverdevice_i.h
 */
#define _NalReadPortOs8(a,p)         NalReadPort8(p)
#define _NalReadPortOs16(a,p)        NalReadPort16(p)
#define _NalReadPortOs32(a,p)        NalReadPort32(p)
#define _NalWritePortOs8(a,p,v)      NalWritePort8(p,v)
#define _NalWritePortOs16(a,p,v)     NalWritePort16(p,v)
#define _NalWritePortOs32(a,p,v)     NalWritePort32(p,v)
#define _NalReadRegisterOs8(a,d)     NalReadRegister8(d)
#define _NalReadRegisterOs16(a,d)    NalReadRegister16(d)
#define _NalReadRegisterOs32(a,d)    NalReadRegister32(d)
#define _NalWriteRegisterOs8(a,d,v)  NalWriteRegister8(d,v)
#define _NalWriteRegisterOs16(a,d,v) NalWriteRegister16(d,v)
#define _NalWriteRegisterOs32(a,d,v) NalWriteRegister32(d,v)

#define NAL_FREEBSD_GET_DRIVER_INFO   3

/* This isnt used for user-mode but it needs SOME definition */
typedef UINTN       NAL_OS_SPECIFIC_DEVICE;

typedef struct _NAL_FREEBSD_DRIVER_INFO {
    UINT32  Command;
    char    Driver[32];             /* driver short name, "tulip", "eepro100" */
    char    Version[32];            /* driver version string */
    char    FirmwareVersion[32];    /* firmware version string, if applicable */
    char    BusInfo[32];            /* Bus info for this IF. */
    char    Reserved1[48];
    char    Reserved2[16];
    UINT32  NetStats;               /* number of u64's from ETHTOOL_GSTATS */
    UINT32  TestInfoLength;
    UINT32  EepromDumpLength;       /* Size of data from ETHTOOL_GEEPROM (bytes) */
    UINT32  RegisterDumpLength;     /* Size of data from ETHTOOL_GREGS (bytes) */
} NAL_FREEBSD_DRIVER_INFO;

typedef struct _NAL_FREEBSD_DEVICE_CONTEXT
{
    BOOLEAN     MarkedInUse;
    KVOID*      KernelModeContext;
    KVOID*      PciDevPtr;
    CHAR        DeviceName[IFNAMSIZ];
    CHAR        DeviceNameWithComma[IFNAMSIZ];
}   NAL_FREEBSD_DEVICE_CONTEXT;


#ifndef NAL_DRIVER
#include <device_t.h>
BOOLEAN
_NalMarkAdapterInUse(
    IN  NAL_ADAPTER_STRUCTURE*  NalAdapter,
    IN  NAL_DEVICE_LOCATION     NalDevice,
    IN  BOOLEAN                 Lock
    );
#endif

KVOID*
_NalAllocateMemoryNonPagedPci(
    IN  KVOID*                  PDev,
    IN  UINT32                  ByteCount,
    IN  UINT32                  Alignment,
    OUT NAL_PHYSICAL_ADDRESS*   PhysicalAddress,
    IN  CHAR*                   NamedLocator,
    IN  UINT32                  LineNumber
    );

VOID
_NalFreeMemoryNonPagedPci(
    IN  KVOID*  PDev,
    IN  KVOID*  Address
    );

#define NalAllocateMemoryNonPagedPci(PDev, ByteCount, Alignment, PhysicalAddress)    \
    _NalAllocateMemoryNonPagedPci((PDev), (ByteCount), (Alignment), (PhysicalAddress), \
                               __FILE__, __LINE__)

#endif /* NAL_INC_FREEBSD_FREEBSDDEVICE_I_H_ */
